(function(){"use strict";var root=this,previous=root.Chart;var Chart=function(context){var chart=this;this.canvas=context.canvas;this.ctx=context;var computeDimension=function(element,dimension)
{if(element['offset'+dimension])
{return element['offset'+dimension];}
else
{return document.defaultView.getComputedStyle(element).getPropertyValue(dimension);}}
var width=this.width=computeDimension(context.canvas,'Width');var height=this.height=computeDimension(context.canvas,'Height');context.canvas.width=width;context.canvas.height=height;var width=this.width=context.canvas.width;var height=this.height=context.canvas.height;this.aspectRatio=this.width / this.height;helpers.retinaScale(this);return this;};Chart.defaults={global:{animation:false,animationSteps:60,animationEasing:"easeOutQuart",showScale:true,scaleOverride:false,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:true,scaleLabel:"<%=value%>",scaleIntegersOnly:true,scaleBeginAtZero:false,scaleFontFamily:"'Lucida Console', 'Monaco', monospace",scaleFontSize:11,scaleFontStyle:"normal",scaleFontColor:"#888",responsive:false,maintainAspectRatio:true,showTooltips:true,customTooltips:false,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(220,220,220,0.9)",tooltipFontFamily:"'Lucida Console', 'Monaco', monospace",tooltipFontSize:12,tooltipFontStyle:"normal",tooltipFontColor:"#222",tooltipTitleFontFamily:"'Lucida Console', 'Monaco', monospace",tooltipTitleFontSize:12,tooltipTitleFontStyle:"normal",tooltipTitleFontColor:"#000",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= value %>",multiTooltipKeyBackground:'#fff',onAnimationProgress:function(){},onAnimationComplete:function(){}}};Chart.types={};var helpers=Chart.helpers={};var each=helpers.each=function(loopable,callback,self){var additionalArgs=Array.prototype.slice.call(arguments,3);if(loopable){if(loopable.length===+loopable.length){var i;for(i=0;i<loopable.length;i++){callback.apply(self,[loopable[i],i].concat(additionalArgs));}}
else{for(var item in loopable){callback.apply(self,[loopable[item],item].concat(additionalArgs));}}}},clone=helpers.clone=function(obj){var objClone={};each(obj,function(value,key){if(obj.hasOwnProperty(key))objClone[key]=value;});return objClone;},extend=helpers.extend=function(base){each(Array.prototype.slice.call(arguments,1),function(extensionObject){each(extensionObject,function(value,key){if(extensionObject.hasOwnProperty(key))base[key]=value;});});return base;},merge=helpers.merge=function(base,master){var args=Array.prototype.slice.call(arguments,0);args.unshift({});return extend.apply(null,args);},indexOf=helpers.indexOf=function(arrayToSearch,item){if(Array.prototype.indexOf){return arrayToSearch.indexOf(item);}
else{for(var i=0;i<arrayToSearch.length;i++){if(arrayToSearch[i]===item)return i;}
return-1;}},where=helpers.where=function(collection,filterCallback){var filtered=[];helpers.each(collection,function(item){if(filterCallback(item)){filtered.push(item);}});return filtered;},findNextWhere=helpers.findNextWhere=function(arrayToSearch,filterCallback,startIndex){if(!startIndex){startIndex=-1;}
for(var i=startIndex+1;i<arrayToSearch.length;i++){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem;}}},findPreviousWhere=helpers.findPreviousWhere=function(arrayToSearch,filterCallback,startIndex){if(!startIndex){startIndex=arrayToSearch.length;}
for(var i=startIndex-1;i>=0;i--){var currentItem=arrayToSearch[i];if(filterCallback(currentItem)){return currentItem;}}},inherits=helpers.inherits=function(extensions){var parent=this;var ChartElement=(extensions&&extensions.hasOwnProperty("constructor"))?extensions.constructor:function(){return parent.apply(this,arguments);};var Surrogate=function(){this.constructor=ChartElement;};Surrogate.prototype=parent.prototype;ChartElement.prototype=new Surrogate();ChartElement.extend=inherits;if(extensions)extend(ChartElement.prototype,extensions);ChartElement.__super__=parent.prototype;return ChartElement;},noop=helpers.noop=function(){},uid=helpers.uid=(function(){var id=0;return function(){return"chart-"+id++;};})(),warn=helpers.warn=function(str){if(window.console&&typeof window.console.warn=="function")console.warn(str);},amd=helpers.amd=(typeof define=='function'&&define.amd),isNumber=helpers.isNumber=function(n){return!isNaN(parseFloat(n))&&isFinite(n);},max=helpers.max=function(array){return Math.max.apply(Math,array);},min=helpers.min=function(array){return Math.min.apply(Math,array);},cap=helpers.cap=function(valueToCap,maxValue,minValue){if(isNumber(maxValue)){if(valueToCap>maxValue){return maxValue;}}
else if(isNumber(minValue)){if(valueToCap<minValue){return minValue;}}
return valueToCap;},getDecimalPlaces=helpers.getDecimalPlaces=function(num){if(num%1!==0&&isNumber(num)){return num.toString().split(".")[1].length;}
else{return 0;}},toRadians=helpers.radians=function(degrees){return degrees*(Math.PI/180);},getAngleFromPoint=helpers.getAngleFromPoint=function(centrePoint,anglePoint){var distanceFromXCenter=anglePoint.x-centrePoint.x,distanceFromYCenter=anglePoint.y-centrePoint.y,radialDistanceFromCenter=Math.sqrt(distanceFromXCenter*distanceFromXCenter+distanceFromYCenter*distanceFromYCenter);var angle=Math.PI*2+Math.atan2(distanceFromYCenter,distanceFromXCenter);if(distanceFromXCenter<0&&distanceFromYCenter<0){angle+=Math.PI*2;}
return{angle:angle,distance:radialDistanceFromCenter};},aliasPixel=helpers.aliasPixel=function(pixelWidth){return(pixelWidth%2===0)?0:0.5;},splineCurve=helpers.splineCurve=function(FirstPoint,MiddlePoint,AfterPoint,t){var d01=Math.sqrt(Math.pow(MiddlePoint.x-FirstPoint.x,2)+Math.pow(MiddlePoint.y-FirstPoint.y,2)),d12=Math.sqrt(Math.pow(AfterPoint.x-MiddlePoint.x,2)+Math.pow(AfterPoint.y-MiddlePoint.y,2)),fa=t*d01/(d01+d12),fb=t*d12/(d01+d12);return{inner:{x:MiddlePoint.x-fa*(AfterPoint.x-FirstPoint.x),y:MiddlePoint.y-fa*(AfterPoint.y-FirstPoint.y)},outer:{x:MiddlePoint.x+fb*(AfterPoint.x-FirstPoint.x),y:MiddlePoint.y+fb*(AfterPoint.y-FirstPoint.y)}};},calculateOrderOfMagnitude=helpers.calculateOrderOfMagnitude=function(val){return Math.floor(Math.log(val)/ Math.LN10);},calculateScaleRange=helpers.calculateScaleRange=function(valuesArray,drawingSize,textSize,startFromZero,integersOnly){var minSteps=2,maxSteps=Math.floor(drawingSize/(textSize*1.5)),skipFitting=(minSteps>=maxSteps);var maxValue=max(valuesArray),minValue=min(valuesArray);if(maxValue===minValue){maxValue+=0.5;if(minValue>=0.5&&!startFromZero){minValue-=0.5;}
else{maxValue+=0.5;}}
var valueRange=Math.abs(maxValue-minValue),rangeOrderOfMagnitude=calculateOrderOfMagnitude(valueRange),graphMax=Math.ceil(maxValue /(1*Math.pow(10,rangeOrderOfMagnitude)))*Math.pow(10,rangeOrderOfMagnitude),graphMin=(startFromZero)?0:Math.floor(minValue /(1*Math.pow(10,rangeOrderOfMagnitude)))*Math.pow(10,rangeOrderOfMagnitude),graphRange=graphMax-graphMin,stepValue=Math.pow(10,rangeOrderOfMagnitude),numberOfSteps=Math.round(graphRange / stepValue);while((numberOfSteps>maxSteps||(numberOfSteps*2)<maxSteps)&&!skipFitting){if(numberOfSteps>maxSteps){stepValue*=2;numberOfSteps=Math.round(graphRange/stepValue);if(numberOfSteps%1!==0){skipFitting=true;}}
else{if(integersOnly&&rangeOrderOfMagnitude>=0){if(stepValue/2%1===0){stepValue /=2;numberOfSteps=Math.round(graphRange/stepValue);}
else{break;}}
else{stepValue /=2;numberOfSteps=Math.round(graphRange/stepValue);}}}
if(skipFitting){numberOfSteps=minSteps;stepValue=graphRange / numberOfSteps;}
return{steps:numberOfSteps,stepValue:stepValue,min:graphMin,max:graphMin+(numberOfSteps*stepValue)};},template=helpers.template=function(templateString,valuesObject){if(templateString instanceof Function){return templateString(valuesObject);}
var cache={};function tmpl(str,data){var fn=!/\W/.test(str)?cache[str]=cache[str]:new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};"+"with(obj){p.push('"+
str.replace(/[\r\t\n]/g," ").split("<%").join("\t").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("\t").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');");return data?fn(data):fn;}
return tmpl(templateString,valuesObject);},generateLabels=helpers.generateLabels=function(templateString,numberOfSteps,graphMin,stepValue){var labelsArray=new Array(numberOfSteps);if(labelTemplateString){each(labelsArray,function(val,index){labelsArray[index]=template(templateString,{value:(graphMin+(stepValue*(index+1)))});});}
return labelsArray;},easingEffects=helpers.easingEffects={linear:function(t){return t;},easeInQuad:function(t){return t*t;},easeOutQuad:function(t){return-1*t*(t-2);},easeInOutQuad:function(t){if((t /=1 / 2)<1)return 1 / 2*t*t;return-1 / 2*((--t)*(t-2)-1);},easeInCubic:function(t){return t*t*t;},easeOutCubic:function(t){return 1*((t=t / 1-1)*t*t+1);},easeInOutCubic:function(t){if((t /=1 / 2)<1)return 1 / 2*t*t*t;return 1 / 2*((t-=2)*t*t+2);},easeInQuart:function(t){return t*t*t*t;},easeOutQuart:function(t){return-1*((t=t / 1-1)*t*t*t-1);},easeInOutQuart:function(t){if((t /=1 / 2)<1)return 1 / 2*t*t*t*t;return-1 / 2*((t-=2)*t*t*t-2);},easeInQuint:function(t){return 1*(t /=1)*t*t*t*t;},easeOutQuint:function(t){return 1*((t=t / 1-1)*t*t*t*t+1);},easeInOutQuint:function(t){if((t /=1 / 2)<1)return 1 / 2*t*t*t*t*t;return 1 / 2*((t-=2)*t*t*t*t+2);},easeInSine:function(t){return-1*Math.cos(t / 1*(Math.PI / 2))+1;},easeOutSine:function(t){return 1*Math.sin(t / 1*(Math.PI / 2));},easeInOutSine:function(t){return-1 / 2*(Math.cos(Math.PI*t / 1)-1);},easeInExpo:function(t){return(t===0)?1:1*Math.pow(2,10*(t / 1-1));},easeOutExpo:function(t){return(t===1)?1:1*(-Math.pow(2,-10*t / 1)+1);},easeInOutExpo:function(t){if(t===0)return 0;if(t===1)return 1;if((t /=1 / 2)<1)return 1 / 2*Math.pow(2,10*(t-1));return 1 / 2*(-Math.pow(2,-10*--t)+2);},easeInCirc:function(t){if(t>=1)return t;return-1*(Math.sqrt(1-(t /=1)*t)-1);},easeOutCirc:function(t){return 1*Math.sqrt(1-(t=t / 1-1)*t);},easeInOutCirc:function(t){if((t /=1 / 2)<1)return-1 / 2*(Math.sqrt(1-t*t)-1);return 1 / 2*(Math.sqrt(1-(t-=2)*t)+1);},easeInElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0)return 0;if((t /=1)==1)return 1;if(!p)p=1*0.3;if(a<Math.abs(1)){a=1;s=p / 4;}else s=p /(2*Math.PI)*Math.asin(1 / a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*1-s)*(2*Math.PI)/ p));},easeOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0)return 0;if((t /=1)==1)return 1;if(!p)p=1*0.3;if(a<Math.abs(1)){a=1;s=p / 4;}else s=p /(2*Math.PI)*Math.asin(1 / a);return a*Math.pow(2,-10*t)*Math.sin((t*1-s)*(2*Math.PI)/ p)+1;},easeInOutElastic:function(t){var s=1.70158;var p=0;var a=1;if(t===0)return 0;if((t /=1 / 2)==2)return 1;if(!p)p=1*(0.3*1.5);if(a<Math.abs(1)){a=1;s=p / 4;}else s=p /(2*Math.PI)*Math.asin(1 / a);if(t<1)return-0.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*1-s)*(2*Math.PI)/ p));return a*Math.pow(2,-10*(t-=1))*Math.sin((t*1-s)*(2*Math.PI)/ p)*0.5+1;},easeInBack:function(t){var s=1.70158;return 1*(t /=1)*t*((s+1)*t-s);},easeOutBack:function(t){var s=1.70158;return 1*((t=t / 1-1)*t*((s+1)*t+s)+1);},easeInOutBack:function(t){var s=1.70158;if((t /=1 / 2)<1)return 1 / 2*(t*t*(((s*=(1.525))+1)*t-s));return 1 / 2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2);},easeInBounce:function(t){return 1-easingEffects.easeOutBounce(1-t);},easeOutBounce:function(t){if((t /=1)<(1 / 2.75)){return 1*(7.5625*t*t);}else if(t<(2 / 2.75)){return 1*(7.5625*(t-=(1.5 / 2.75))*t+0.75);}else if(t<(2.5 / 2.75)){return 1*(7.5625*(t-=(2.25 / 2.75))*t+0.9375);}else{return 1*(7.5625*(t-=(2.625 / 2.75))*t+0.984375);}},easeInOutBounce:function(t){if(t<1 / 2)return easingEffects.easeInBounce(t*2)*0.5;return easingEffects.easeOutBounce(t*2-1)*0.5+1*0.5;}},requestAnimFrame=helpers.requestAnimFrame=(function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback){return window.setTimeout(callback,1000 / 60);};})(),cancelAnimFrame=helpers.cancelAnimFrame=(function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(callback){return window.clearTimeout(callback,1000 / 60);};})(),animationLoop=helpers.animationLoop=function(callback,totalSteps,easingString,onProgress,onComplete,chartInstance){var currentStep=0,easingFunction=easingEffects[easingString]||easingEffects.linear;var animationFrame=function(){currentStep++;var stepDecimal=currentStep/totalSteps;var easeDecimal=easingFunction(stepDecimal);callback.call(chartInstance,easeDecimal,stepDecimal,currentStep);onProgress.call(chartInstance,easeDecimal,stepDecimal);if(currentStep<totalSteps){chartInstance.animationFrame=requestAnimFrame(animationFrame);}else{onComplete.apply(chartInstance);}};requestAnimFrame(animationFrame);},getRelativePosition=helpers.getRelativePosition=function(evt){var mouseX,mouseY;var e=evt.originalEvent||evt,canvas=evt.currentTarget||evt.srcElement,boundingRect=canvas.getBoundingClientRect();if(e.touches){mouseX=e.touches[0].clientX-boundingRect.left;mouseY=e.touches[0].clientY-boundingRect.top;}
else{mouseX=e.clientX-boundingRect.left;mouseY=e.clientY-boundingRect.top;}
return{x:mouseX,y:mouseY};},addEvent=helpers.addEvent=function(node,eventType,method){if(node.addEventListener){node.addEventListener(eventType,method);}else if(node.attachEvent){node.attachEvent("on"+eventType,method);}else{node["on"+eventType]=method;}},removeEvent=helpers.removeEvent=function(node,eventType,handler){if(node.removeEventListener){node.removeEventListener(eventType,handler,false);}else if(node.detachEvent){node.detachEvent("on"+eventType,handler);}else{node["on"+eventType]=noop;}},bindEvents=helpers.bindEvents=function(chartInstance,arrayOfEvents,handler){if(!chartInstance.events)chartInstance.events={};each(arrayOfEvents,function(eventName){chartInstance.events[eventName]=function(){handler.apply(chartInstance,arguments);};addEvent(chartInstance.chart.canvas,eventName,chartInstance.events[eventName]);});},unbindEvents=helpers.unbindEvents=function(chartInstance,arrayOfEvents){each(arrayOfEvents,function(handler,eventName){removeEvent(chartInstance.chart.canvas,eventName,handler);});},getMaximumWidth=helpers.getMaximumWidth=function(domNode){var container=domNode.parentNode;return container.clientWidth;},getMaximumHeight=helpers.getMaximumHeight=function(domNode){var container=domNode.parentNode;return container.clientHeight;},getMaximumSize=helpers.getMaximumSize=helpers.getMaximumWidth,retinaScale=helpers.retinaScale=function(chart){var ctx=chart.ctx,width=chart.canvas.width,height=chart.canvas.height;if(window.devicePixelRatio){ctx.canvas.style.width=width+"px";ctx.canvas.style.height=height+"px";ctx.canvas.height=height*window.devicePixelRatio;ctx.canvas.width=width*window.devicePixelRatio;ctx.scale(window.devicePixelRatio,window.devicePixelRatio);}},clear=helpers.clear=function(chart){chart.ctx.clearRect(0,0,chart.width,chart.height);},fontString=helpers.fontString=function(pixelSize,fontStyle,fontFamily){return fontStyle+" "+pixelSize+"px "+fontFamily;},longestText=helpers.longestText=function(ctx,font,arrayOfStrings){ctx.font=font;var longest=0;each(arrayOfStrings,function(string){var textWidth=ctx.measureText(string).width;longest=(textWidth>longest)?textWidth:longest;});return longest;},drawRoundedRectangle=helpers.drawRoundedRectangle=function(ctx,x,y,width,height,radius){ctx.beginPath();ctx.moveTo(x+radius,y);ctx.lineTo(x+width-radius,y);ctx.quadraticCurveTo(x+width,y,x+width,y+radius);ctx.lineTo(x+width,y+height-radius);ctx.quadraticCurveTo(x+width,y+height,x+width-radius,y+height);ctx.lineTo(x+radius,y+height);ctx.quadraticCurveTo(x,y+height,x,y+height-radius);ctx.lineTo(x,y+radius);ctx.quadraticCurveTo(x,y,x+radius,y);ctx.closePath();};Chart.instances={};Chart.Type=function(data,options,chart){this.options=options;this.chart=chart;this.id=uid();Chart.instances[this.id]=this;if(options.responsive){this.resize();}
this.initialize.call(this,data);};extend(Chart.Type.prototype,{initialize:function(){return this;},clear:function(){clear(this.chart);return this;},stop:function(){cancelAnimFrame(this.animationFrame);return this;},resize:function(callback){this.stop();var canvas=this.chart.canvas,newWidth=getMaximumWidth(this.chart.canvas),newHeight=this.options.maintainAspectRatio?newWidth / this.chart.aspectRatio:getMaximumHeight(this.chart.canvas);canvas.width=this.chart.width=newWidth;canvas.height=this.chart.height=newHeight;retinaScale(this.chart);if(typeof callback==="function"){callback.apply(this,Array.prototype.slice.call(arguments,1));}
return this;},reflow:noop,render:function(reflow){if(reflow){this.reflow();}
if(this.options.animation&&!reflow){helpers.animationLoop(this.draw,this.options.animationSteps,this.options.animationEasing,this.options.onAnimationProgress,this.options.onAnimationComplete,this);}
else{this.draw();this.options.onAnimationComplete.call(this);}
return this;},generateLegend:function(){return template(this.options.legendTemplate,this);},destroy:function(){this.clear();unbindEvents(this,this.events);var canvas=this.chart.canvas;canvas.width=this.chart.width;canvas.height=this.chart.height;if(canvas.style.removeProperty){canvas.style.removeProperty('width');canvas.style.removeProperty('height');}else{canvas.style.removeAttribute('width');canvas.style.removeAttribute('height');}
delete Chart.instances[this.id];},showTooltip:function(ChartElements,forceRedraw){if(typeof this.activeElements==='undefined')this.activeElements=[];var isChanged=(function(Elements){var changed=false;if(Elements.length!==this.activeElements.length){changed=true;return changed;}
each(Elements,function(element,index){if(element!==this.activeElements[index]){changed=true;}},this);return changed;}).call(this,ChartElements);if(!isChanged&&!forceRedraw){return;}
else{this.activeElements=ChartElements;}
this.draw();if(this.options.customTooltips){this.options.customTooltips(false);}
if(ChartElements.length>0){if(this.datasets&&this.datasets.length>1){var dataArray,dataIndex;for(var i=this.datasets.length-1;i>=0;i--){dataArray=this.datasets[i].points||this.datasets[i].bars||this.datasets[i].segments;dataIndex=indexOf(dataArray,ChartElements[0]);if(dataIndex!==-1){break;}}
var tooltipLabels=[],tooltipColors=[],medianPosition=(function(index){var Elements=[],dataCollection,xPositions=[],yPositions=[],xMax,yMax,xMin,yMin;helpers.each(this.datasets,function(dataset){dataCollection=dataset.points||dataset.bars||dataset.segments;if(dataCollection[dataIndex]&&dataCollection[dataIndex].hasValue()){Elements.push(dataCollection[dataIndex]);}});helpers.each(Elements,function(element){xPositions.push(element.x);yPositions.push(element.y);tooltipLabels.push(helpers.template(this.options.multiTooltipTemplate,element));tooltipColors.push({fill:element._saved.fillColor||element.fillColor,stroke:element._saved.strokeColor||element.strokeColor});},this);yMin=min(yPositions);yMax=max(yPositions);xMin=min(xPositions);xMax=max(xPositions);return{x:(xMin>this.chart.width/2)?xMin:xMax,y:(yMin+yMax)/2};}).call(this,dataIndex);new Chart.MultiTooltip({x:medianPosition.x,y:medianPosition.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:tooltipLabels,legendColors:tooltipColors,legendColorBackground:this.options.multiTooltipKeyBackground,title:this.datasets[0].points[dataIndex].time,chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw();}else{each(ChartElements,function(Element){var tooltipPosition=Element.tooltipPosition();new Chart.Tooltip({x:Math.round(tooltipPosition.x),y:Math.round(tooltipPosition.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:template(this.options.tooltipTemplate,Element),chart:this.chart,custom:this.options.customTooltips}).draw();},this);}}
return this;},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments);}});Chart.Type.extend=function(extensions){var parent=this;var ChartType=function(){return parent.apply(this,arguments);};ChartType.prototype=clone(parent.prototype);extend(ChartType.prototype,extensions);ChartType.extend=Chart.Type.extend;if(extensions.name||parent.prototype.name){var chartName=extensions.name||parent.prototype.name;var baseDefaults=(Chart.defaults[parent.prototype.name])?clone(Chart.defaults[parent.prototype.name]):{};Chart.defaults[chartName]=extend(baseDefaults,extensions.defaults);Chart.types[chartName]=ChartType;Chart.prototype[chartName]=function(data,options){var config=merge(Chart.defaults.global,Chart.defaults[chartName],options||{});return new ChartType(data,config,this);};}else{warn("Name not provided for this chart, so it hasn't been registered");}
return parent;};Chart.Element=function(configuration){extend(this,configuration);this.initialize.apply(this,arguments);this.save();};extend(Chart.Element.prototype,{initialize:function(){},restore:function(props){if(!props){extend(this,this._saved);}else{each(props,function(key){this[key]=this._saved[key];},this);}
return this;},save:function(){this._saved=clone(this);delete this._saved._saved;return this;},update:function(newProps){each(newProps,function(value,key){this._saved[key]=this[key];this[key]=value;},this);return this;},transition:function(props,ease){each(props,function(value,key){this[key]=((value-this._saved[key])*ease)+this._saved[key];},this);return this;},tooltipPosition:function(){return{x:this.x,y:this.y};},hasValue:function(){return isNumber(this.value);}});Chart.Element.extend=inherits;Chart.Point=Chart.Element.extend({display:true,inRange:function(chartX,chartY){var hitDetectionRange=this.hitDetectionRadius+this.radius;return((Math.pow(chartX-this.x,2)+Math.pow(chartY-this.y,2))<Math.pow(hitDetectionRange,2));},draw:function(){if(this.display){var ctx=this.ctx;ctx.beginPath();ctx.arc(this.x,this.y,this.radius,0,Math.PI*2);ctx.closePath();ctx.strokeStyle=this.strokeColor;ctx.lineWidth=this.strokeWidth;ctx.fillStyle=this.fillColor;ctx.fill();ctx.stroke();}}});Chart.Arc=Chart.Element.extend({inRange:function(chartX,chartY){var pointRelativePosition=helpers.getAngleFromPoint(this,{x:chartX,y:chartY});var betweenAngles=(pointRelativePosition.angle>=this.startAngle&&pointRelativePosition.angle<=this.endAngle),withinRadius=(pointRelativePosition.distance>=this.innerRadius&&pointRelativePosition.distance<=this.outerRadius);return(betweenAngles&&withinRadius);},tooltipPosition:function(){var centreAngle=this.startAngle+((this.endAngle-this.startAngle)/ 2),rangeFromCentre=(this.outerRadius-this.innerRadius)/ 2+this.innerRadius;return{x:this.x+(Math.cos(centreAngle)*rangeFromCentre),y:this.y+(Math.sin(centreAngle)*rangeFromCentre)};},draw:function(animationPercent){var easingDecimal=animationPercent||1;var ctx=this.ctx;ctx.beginPath();ctx.arc(this.x,this.y,this.outerRadius,this.startAngle,this.endAngle);ctx.arc(this.x,this.y,this.innerRadius,this.endAngle,this.startAngle,true);ctx.closePath();ctx.strokeStyle=this.strokeColor;ctx.lineWidth=this.strokeWidth;ctx.fillStyle=this.fillColor;ctx.fill();ctx.lineJoin='bevel';if(this.showStroke){ctx.stroke();}}});Chart.Rectangle=Chart.Element.extend({draw:function(){var ctx=this.ctx,halfWidth=this.width/2,leftX=this.x-halfWidth,rightX=this.x+halfWidth,top=this.base-(this.base-this.y),halfStroke=this.strokeWidth / 2;if(this.showStroke){leftX+=halfStroke;rightX-=halfStroke;top+=halfStroke;}
ctx.beginPath();ctx.fillStyle=this.fillColor;ctx.strokeStyle=this.strokeColor;ctx.lineWidth=this.strokeWidth;ctx.moveTo(leftX,this.base);ctx.lineTo(leftX,top);ctx.lineTo(rightX,top);ctx.lineTo(rightX,this.base);ctx.fill();if(this.showStroke){ctx.stroke();}},height:function(){return this.base-this.y;},inRange:function(chartX,chartY){return(chartX>=this.x-this.width/2&&chartX<=this.x+this.width/2)&&(chartY>=this.y&&chartY<=this.base);}});Chart.Tooltip=Chart.Element.extend({draw:function(){var ctx=this.chart.ctx;ctx.font=fontString(this.fontSize,this.fontStyle,this.fontFamily);this.xAlign="center";this.yAlign="above";var caretPadding=this.caretPadding=2;var tooltipWidth=ctx.measureText(this.text).width+2*this.xPadding,tooltipRectHeight=this.fontSize+2*this.yPadding,tooltipHeight=tooltipRectHeight+this.caretHeight+caretPadding;if(this.x+tooltipWidth/2>this.chart.width){this.xAlign="left";}else if(this.x-tooltipWidth/2<0){this.xAlign="right";}
if(this.y-tooltipHeight<0){this.yAlign="below";}
var tooltipX=this.x-tooltipWidth/2,tooltipY=this.y-tooltipHeight;ctx.fillStyle=this.fillColor;if(this.custom){this.custom(this);}
else{switch(this.yAlign)
{case"above":ctx.beginPath();ctx.moveTo(this.x,this.y-caretPadding);ctx.lineTo(this.x+this.caretHeight,this.y-(caretPadding+this.caretHeight));ctx.lineTo(this.x-this.caretHeight,this.y-(caretPadding+this.caretHeight));ctx.closePath();ctx.fill();break;case"below":tooltipY=this.y+caretPadding+this.caretHeight;ctx.beginPath();ctx.moveTo(this.x,this.y+caretPadding);ctx.lineTo(this.x+this.caretHeight,this.y+caretPadding+this.caretHeight);ctx.lineTo(this.x-this.caretHeight,this.y+caretPadding+this.caretHeight);ctx.closePath();ctx.fill();break;}
switch(this.xAlign)
{case"left":tooltipX=this.x-tooltipWidth+(this.cornerRadius+this.caretHeight);break;case"right":tooltipX=this.x-(this.cornerRadius+this.caretHeight);break;}
drawRoundedRectangle(ctx,tooltipX,tooltipY,tooltipWidth,tooltipRectHeight,this.cornerRadius);ctx.fill();ctx.fillStyle=this.textColor;ctx.textAlign="center";ctx.textBaseline="middle";ctx.fillText(this.text,tooltipX+tooltipWidth/2,tooltipY+tooltipRectHeight/2);}}});Chart.MultiTooltip=Chart.Element.extend({initialize:function(){this.font=fontString(this.fontSize,this.fontStyle,this.fontFamily);this.titleFont=fontString(this.titleFontSize,this.titleFontStyle,this.titleFontFamily);this.height=(this.labels.length*this.fontSize)+((this.labels.length-1)*(this.fontSize/2))+(this.yPadding*2)+this.titleFontSize*1.5;this.ctx.font=this.titleFont;var titleWidth=this.ctx.measureText(this.title).width,labelWidth=longestText(this.ctx,this.font,this.labels)+this.fontSize+3,longestTextWidth=max([labelWidth,titleWidth]);this.width=longestTextWidth+(this.xPadding*2);var halfHeight=this.height/2;if(this.y-halfHeight<0){this.y=halfHeight;}else if(this.y+halfHeight>this.chart.height){this.y=this.chart.height-halfHeight;}
if(this.x>this.chart.width/2){this.x-=this.xOffset+this.width;}else{this.x+=this.xOffset;}},getLineHeight:function(index){var baseLineHeight=this.y-(this.height/2)+this.yPadding,afterTitleIndex=index-1;if(index===0){return baseLineHeight+this.titleFontSize/2;}else{return baseLineHeight+((this.fontSize*1.5*afterTitleIndex)+this.fontSize/2)+this.titleFontSize*1.5;}},draw:function(){if(this.custom){this.custom(this);}
else{drawRoundedRectangle(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var ctx=this.ctx;ctx.fillStyle=this.fillColor;ctx.fill();ctx.closePath();ctx.textAlign="left";ctx.textBaseline="middle";ctx.fillStyle=this.titleTextColor;ctx.font=this.titleFont;ctx.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0));ctx.font=this.font;helpers.each(this.labels,function(label,index){var n=label.length;if(label.length==1 && label.substr(n-1,1)=='A')label=parseFloat(label.substring(0,n-1)/100).toFixed(4)+" A";if(label.substr(n-1,1)=='φ')label=parseFloat(label.substring(0,n-4)/100).toFixed(4)+" cosφ";ctx.fillStyle=this.textColor;ctx.fillText(label,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(index+1));ctx.fillStyle=this.legendColorBackground;ctx.fillRect(this.x+this.xPadding,this.getLineHeight(index+1)-this.fontSize/2,this.fontSize,this.fontSize);ctx.fillStyle=this.legendColors[index].fill;ctx.fillRect(this.x+this.xPadding,this.getLineHeight(index+1)-this.fontSize/2,this.fontSize,this.fontSize);},this);}}});Chart.Scale=Chart.Element.extend({initialize:function(){this.fit();},buildYLabels:function(){this.yLabels=[];var stepDecimalPlaces=getDecimalPlaces(this.stepValue);for(var i=0;i<=this.steps;i++){this.yLabels.push(template(this.templateString,{value:(this.min+(i*this.stepValue)).toFixed(stepDecimalPlaces)}));}
this.yLabelWidth=(this.display&&this.showLabels)?longestText(this.ctx,this.font,this.yLabels):0;},addXLabel:function(label){this.xLabels.push(label);this.valuesCount++;this.fit();},removeXLabel:function(){this.xLabels.shift();this.valuesCount--;this.fit();},fit:function(){this.startPoint=(this.display)?this.fontSize:0;this.endPoint=(this.display)?this.height-(this.fontSize*1.5)-5:this.height;this.startPoint+=this.padding;this.endPoint-=this.padding;var cachedHeight=this.endPoint-this.startPoint,cachedYLabelWidth;this.calculateYRange(cachedHeight);this.buildYLabels();this.calculateXLabelRotation();while((cachedHeight>this.endPoint-this.startPoint)){cachedHeight=this.endPoint-this.startPoint;cachedYLabelWidth=this.yLabelWidth;this.calculateYRange(cachedHeight);this.buildYLabels();if(cachedYLabelWidth<this.yLabelWidth){this.calculateXLabelRotation();}}},calculateXLabelRotation:function(){this.ctx.font=this.font;var firstWidth=this.ctx.measureText(this.xLabels[0]).width,lastWidth=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width,firstRotated,lastRotated;this.xScalePaddingRight=lastWidth/2+3;this.xScalePaddingLeft=(firstWidth/2>this.yLabelWidth+10)?firstWidth/2:this.yLabelWidth+10;this.xLabelRotation=0;if(this.display){var originalLabelWidth=longestText(this.ctx,this.font,this.xLabels),cosRotation,firstRotatedWidth;this.xLabelWidth=originalLabelWidth;var xGridWidth=Math.floor(this.calculateX(1)-this.calculateX(0))-6;while((this.xLabelWidth>xGridWidth&&this.xLabelRotation===0)||(this.xLabelWidth>xGridWidth&&this.xLabelRotation<=90&&this.xLabelRotation>0)){cosRotation=Math.cos(toRadians(this.xLabelRotation));firstRotated=cosRotation*firstWidth;lastRotated=cosRotation*lastWidth;if(firstRotated+this.fontSize / 2>this.yLabelWidth+8){this.xScalePaddingLeft=firstRotated+this.fontSize / 2;}
this.xScalePaddingRight=this.fontSize/2;this.xLabelRotation++;this.xLabelWidth=cosRotation*originalLabelWidth;}
if(this.xLabelRotation>0){this.endPoint-=Math.sin(toRadians(this.xLabelRotation))*originalLabelWidth+3;}}
else{this.xLabelWidth=0;this.xScalePaddingRight=this.padding;this.xScalePaddingLeft=this.padding;}},calculateYRange:noop,drawingArea:function(){return this.startPoint-this.endPoint;},calculateY:function(value){var scalingFactor=this.drawingArea()/(this.min-this.max);return this.endPoint-(scalingFactor*(value-this.min));},calculateX:function(index){var isRotated=(this.xLabelRotation>0),innerWidth=this.width-(this.xScalePaddingLeft+this.xScalePaddingRight),valueWidth=innerWidth/Math.max((this.valuesCount-((this.offsetGridLines)?0:1)),1),valueOffset=(valueWidth*index)+this.xScalePaddingLeft;if(this.offsetGridLines){valueOffset+=(valueWidth/2);}
return Math.round(valueOffset);},update:function(newProps){helpers.extend(this,newProps);this.fit();},draw:function(){var ctx=this.ctx,yLabelGap=(this.endPoint-this.startPoint)/ this.steps,xStart=Math.round(this.xScalePaddingLeft);if(this.display){ctx.fillStyle=this.textColor;ctx.font=this.font;each(this.yLabels,function(labelString,index){var yLabelCenter=this.endPoint-(yLabelGap*index),linePositionY=Math.round(yLabelCenter),drawHorizontalLine=this.showHorizontalLines;ctx.textAlign="right";ctx.textBaseline="middle";if(this.showLabels){ctx.fillText(labelString,xStart-10,yLabelCenter);}
if(index===0&&!drawHorizontalLine){drawHorizontalLine=true;}
if(drawHorizontalLine){ctx.beginPath();}
if(index>0){ctx.lineWidth=this.gridLineWidth;ctx.strokeStyle=this.gridLineColor;}else{ctx.lineWidth=this.lineWidth;ctx.strokeStyle=this.lineColor;}
linePositionY+=helpers.aliasPixel(ctx.lineWidth);if(drawHorizontalLine){ctx.moveTo(xStart,linePositionY);ctx.lineTo(this.width,linePositionY);ctx.stroke();ctx.closePath();}
ctx.lineWidth=this.lineWidth;ctx.strokeStyle=this.lineColor;ctx.beginPath();ctx.moveTo(xStart-5,linePositionY);ctx.lineTo(xStart,linePositionY);ctx.stroke();ctx.closePath();},this);each(this.xLabels,function(label,index){var xPos=this.calculateX(index)+aliasPixel(this.lineWidth),linePos=this.calculateX(index-(this.offsetGridLines?0.5:0))+aliasPixel(this.lineWidth),isRotated=(this.xLabelRotation>0),drawVerticalLine=this.showVerticalLines;if(index===0&&!drawVerticalLine){drawVerticalLine=true;}
if(drawVerticalLine){ctx.beginPath();}
if(index>0){ctx.lineWidth=this.gridLineWidth;ctx.strokeStyle=this.gridLineColor;}else{ctx.lineWidth=this.lineWidth;ctx.strokeStyle=this.lineColor;}
if(drawVerticalLine){ctx.moveTo(linePos,this.endPoint);ctx.lineTo(linePos,this.startPoint-3);ctx.stroke();ctx.closePath();}
ctx.lineWidth=this.lineWidth;ctx.strokeStyle=this.lineColor;ctx.beginPath();ctx.moveTo(linePos,this.endPoint);ctx.lineTo(linePos,this.endPoint+5);ctx.stroke();ctx.closePath();ctx.save();ctx.translate(xPos,(isRotated)?this.endPoint+12:this.endPoint+8);ctx.rotate(toRadians(this.xLabelRotation)*-1);ctx.font=this.font;ctx.textAlign=(isRotated)?"right":"center";ctx.textBaseline=(isRotated)?"middle":"top";ctx.fillText(label,0,0);ctx.restore();},this);}}});Chart.RadialScale=Chart.Element.extend({initialize:function(){this.size=min([this.height,this.width]);this.drawingArea=(this.display)?(this.size/2)-(this.fontSize/2+this.backdropPaddingY):(this.size/2);},calculateCenterOffset:function(value){var scalingFactor=this.drawingArea /(this.max-this.min);return(value-this.min)*scalingFactor;},update:function(){if(!this.lineArc){this.setScaleSize();}else{this.drawingArea=(this.display)?(this.size/2)-(this.fontSize/2+this.backdropPaddingY):(this.size/2);}
this.buildYLabels();},buildYLabels:function(){this.yLabels=[];var stepDecimalPlaces=getDecimalPlaces(this.stepValue);for(var i=0;i<=this.steps;i++){this.yLabels.push(template(this.templateString,{value:(this.min+(i*this.stepValue)).toFixed(stepDecimalPlaces)}));}},getCircumference:function(){return((Math.PI*2)/ this.valuesCount);},setScaleSize:function(){var largestPossibleRadius=min([(this.height/2-this.pointLabelFontSize-5),this.width/2]),pointPosition,i,textWidth,halfTextWidth,furthestRight=this.width,furthestRightIndex,furthestRightAngle,furthestLeft=0,furthestLeftIndex,furthestLeftAngle,xProtrusionLeft,xProtrusionRight,radiusReductionRight,radiusReductionLeft,maxWidthRadius;this.ctx.font=fontString(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);for(i=0;i<this.valuesCount;i++){pointPosition=this.getPointPosition(i,largestPossibleRadius);textWidth=this.ctx.measureText(template(this.templateString,{value:this.labels[i]})).width+5;if(i===0||i===this.valuesCount/2){halfTextWidth=textWidth/2;if(pointPosition.x+halfTextWidth>furthestRight){furthestRight=pointPosition.x+halfTextWidth;furthestRightIndex=i;}
if(pointPosition.x-halfTextWidth<furthestLeft){furthestLeft=pointPosition.x-halfTextWidth;furthestLeftIndex=i;}}
else if(i<this.valuesCount/2){if(pointPosition.x+textWidth>furthestRight){furthestRight=pointPosition.x+textWidth;furthestRightIndex=i;}}
else if(i>this.valuesCount/2){if(pointPosition.x-textWidth<furthestLeft){furthestLeft=pointPosition.x-textWidth;furthestLeftIndex=i;}}}
xProtrusionLeft=furthestLeft;xProtrusionRight=Math.ceil(furthestRight-this.width);furthestRightAngle=this.getIndexAngle(furthestRightIndex);furthestLeftAngle=this.getIndexAngle(furthestLeftIndex);radiusReductionRight=xProtrusionRight / Math.sin(furthestRightAngle+Math.PI/2);radiusReductionLeft=xProtrusionLeft / Math.sin(furthestLeftAngle+Math.PI/2);radiusReductionRight=(isNumber(radiusReductionRight))?radiusReductionRight:0;radiusReductionLeft=(isNumber(radiusReductionLeft))?radiusReductionLeft:0;this.drawingArea=largestPossibleRadius-(radiusReductionLeft+radiusReductionRight)/2;this.setCenterPoint(radiusReductionLeft,radiusReductionRight);},setCenterPoint:function(leftMovement,rightMovement){var maxRight=this.width-rightMovement-this.drawingArea,maxLeft=leftMovement+this.drawingArea;this.xCenter=(maxLeft+maxRight)/2;this.yCenter=(this.height/2);},getIndexAngle:function(index){var angleMultiplier=(Math.PI*2)/ this.valuesCount;return index*angleMultiplier-(Math.PI/2);},getPointPosition:function(index,distanceFromCenter){var thisAngle=this.getIndexAngle(index);return{x:(Math.cos(thisAngle)*distanceFromCenter)+this.xCenter,y:(Math.sin(thisAngle)*distanceFromCenter)+this.yCenter};},draw:function(){if(this.display){var ctx=this.ctx;each(this.yLabels,function(label,index){if(index>0){var yCenterOffset=index*(this.drawingArea/this.steps),yHeight=this.yCenter-yCenterOffset,pointPosition;if(this.lineWidth>0){ctx.strokeStyle=this.lineColor;ctx.lineWidth=this.lineWidth;if(this.lineArc){ctx.beginPath();ctx.arc(this.xCenter,this.yCenter,yCenterOffset,0,Math.PI*2);ctx.closePath();ctx.stroke();}else{ctx.beginPath();for(var i=0;i<this.valuesCount;i++)
{pointPosition=this.getPointPosition(i,this.calculateCenterOffset(this.min+(index*this.stepValue)));if(i===0){ctx.moveTo(pointPosition.x,pointPosition.y);}else{ctx.lineTo(pointPosition.x,pointPosition.y);}}
ctx.closePath();ctx.stroke();}}
if(this.showLabels){ctx.font=fontString(this.fontSize,this.fontStyle,this.fontFamily);if(this.showLabelBackdrop){var labelWidth=ctx.measureText(label).width;ctx.fillStyle=this.backdropColor;ctx.fillRect(this.xCenter-labelWidth/2-this.backdropPaddingX,yHeight-this.fontSize/2-this.backdropPaddingY,labelWidth+this.backdropPaddingX*2,this.fontSize+this.backdropPaddingY*2);}
ctx.textAlign='center';ctx.textBaseline="middle";ctx.fillStyle=this.fontColor;ctx.fillText(label,this.xCenter,yHeight);}}},this);if(!this.lineArc){ctx.lineWidth=this.angleLineWidth;ctx.strokeStyle=this.angleLineColor;for(var i=this.valuesCount-1;i>=0;i--){if(this.angleLineWidth>0){var outerPosition=this.getPointPosition(i,this.calculateCenterOffset(this.max));ctx.beginPath();ctx.moveTo(this.xCenter,this.yCenter);ctx.lineTo(outerPosition.x,outerPosition.y);ctx.stroke();ctx.closePath();}
var pointLabelPosition=this.getPointPosition(i,this.calculateCenterOffset(this.max)+5);ctx.font=fontString(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily);ctx.fillStyle=this.pointLabelFontColor;var labelsCount=this.labels.length,halfLabelsCount=this.labels.length/2,quarterLabelsCount=halfLabelsCount/2,upperHalf=(i<quarterLabelsCount||i>labelsCount-quarterLabelsCount),exactQuarter=(i===quarterLabelsCount||i===labelsCount-quarterLabelsCount);if(i===0){ctx.textAlign='center';}else if(i===halfLabelsCount){ctx.textAlign='center';}else if(i<halfLabelsCount){ctx.textAlign='left';}else{ctx.textAlign='right';}
if(exactQuarter){ctx.textBaseline='middle';}else if(upperHalf){ctx.textBaseline='bottom';}else{ctx.textBaseline='top';}
ctx.fillText(this.labels[i],pointLabelPosition.x,pointLabelPosition.y);}}}}});helpers.addEvent(window,"resize",(function(){var timeout;return function(){clearTimeout(timeout);timeout=setTimeout(function(){each(Chart.instances,function(instance){if(instance.options.responsive){instance.resize(instance.render,true);}});},50);};})());if(amd){define(function(){return Chart;});}else if(typeof module==='object'&&module.exports){module.exports=Chart;}
root.Chart=Chart;Chart.noConflict=function(){root.Chart=previous;return Chart;};}).call(this);(function(){"use strict";var root=this,Chart=root.Chart,helpers=Chart.helpers;var defaultConfig={scaleShowGridLines:false,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:true,scaleShowVerticalLines:true,bezierCurve:true,bezierCurveTension:0.3,pointDot:false,pointDotRadius:2,pointDotStrokeWidth:1,pointHitDetectionRadius:10,datasetStroke:true,datasetStrokeWidth:1,datasetFill:false,legendTemplate:"<ul class=\"<%=name.toLowerCase()%>-legend\"><% for (var i=0; i<datasets.length; i++){%><li><span style=\"background-color:<%=datasets[i].strokeColor%>\"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>"};Chart.Type.extend({name:"Line",defaults:defaultConfig,initialize:function(data){this.PointClass=Chart.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(mouseX){return(Math.pow(mouseX-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2));}});this.datasets=[];if(this.options.showTooltips){helpers.bindEvents(this,this.options.tooltipEvents,function(evt){var activePoints=(evt.type!=='mouseout')?this.getPointsAtEvent(evt):[];this.eachPoints(function(point){point.restore(['fillColor','strokeColor']);});helpers.each(activePoints,function(activePoint){activePoint.fillColor=activePoint.highlightFill;activePoint.strokeColor=activePoint.highlightStroke;});this.showTooltip(activePoints);});}
helpers.each(data.datasets,function(dataset){var datasetObject={label:dataset.label||null,fillColor:dataset.fillColor,strokeColor:dataset.strokeColor,pointColor:dataset.pointColor,pointStrokeColor:dataset.pointStrokeColor,points:[]};this.datasets.push(datasetObject);helpers.each(dataset.data,function(dataPoint,index){datasetObject.points.push(new this.PointClass({value:dataPoint,time:c_time_s_ar[index],label:dataset.label,datasetLabel:dataset.label,strokeColor:dataset.pointStrokeColor,fillColor:dataset.pointColor,highlightFill:dataset.pointHighlightFill||dataset.pointColor,highlightStroke:dataset.pointHighlightStroke||dataset.pointStrokeColor}));},this);this.buildScale(data.labels);this.eachPoints(function(point,index){helpers.extend(point,{x:this.scale.calculateX(index),y:this.scale.endPoint});point.save();},this);},this);this.render();},update:function(){this.scale.update();helpers.each(this.activeElements,function(activeElement){activeElement.restore(['fillColor','strokeColor']);});this.eachPoints(function(point){point.save();});this.render();},eachPoints:function(callback){helpers.each(this.datasets,function(dataset){helpers.each(dataset.points,callback,this);},this);},getPointsAtEvent:function(e){var pointsArray=[],eventPosition=helpers.getRelativePosition(e);helpers.each(this.datasets,function(dataset){helpers.each(dataset.points,function(point){if(point.inRange(eventPosition.x,eventPosition.y))pointsArray.push(point);});},this);return pointsArray;},buildScale:function(labels){var self=this;var dataTotal=function(){var values=[];self.eachPoints(function(point){values.push(point.value);});return values;};var scaleOptions={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:labels.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(currentHeight){var updatedRanges=helpers.calculateScaleRange(dataTotal(),currentHeight,this.fontSize,this.beginAtZero,this.integersOnly);helpers.extend(this,updatedRanges);},xLabels:labels,font:helpers.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:(this.options.scaleShowGridLines)?this.options.scaleGridLineWidth:0,gridLineColor:(this.options.scaleShowGridLines)?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:(this.options.showScale)?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};if(this.options.scaleOverride){helpers.extend(scaleOptions,{calculateYRange:helpers.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+(this.options.scaleSteps*this.options.scaleStepWidth)});}
this.scale=new Chart.Scale(scaleOptions);},addData:function(valuesArray,tooltipArray,label,add_time){helpers.each(valuesArray,function(value,datasetIndex){this.datasets[datasetIndex].points.push(new this.PointClass({value:value,label:tooltipArray[datasetIndex],time:add_time,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[datasetIndex].pointStrokeColor,fillColor:this.datasets[datasetIndex].pointColor,}));},this);this.scale.addXLabel(label);this.update();},removeData:function(){this.scale.removeXLabel();helpers.each(this.datasets,function(dataset){dataset.points.shift();},this);this.update();},reflow:function(){var newScaleProps=helpers.extend({height:this.chart.height,width:this.chart.width});this.scale.update(newScaleProps);},draw:function(ease){var easingDecimal=ease||1;this.clear();var ctx=this.chart.ctx;var hasValue=function(item){return item.value!==null;},nextPoint=function(point,collection,index){return helpers.findNextWhere(collection,hasValue,index)||point;},previousPoint=function(point,collection,index){return helpers.findPreviousWhere(collection,hasValue,index)||point;};this.scale.draw(easingDecimal);helpers.each(this.datasets,function(dataset){var pointsWithValues=helpers.where(dataset.points,hasValue);helpers.each(dataset.points,function(point,index){if(point.hasValue()){point.transition({y:this.scale.calculateY(point.value),x:this.scale.calculateX(index)},easingDecimal);}},this);if(this.options.bezierCurve){helpers.each(pointsWithValues,function(point,index){var tension=(index>0&&index<pointsWithValues.length-1)?this.options.bezierCurveTension:0;point.controlPoints=helpers.splineCurve(previousPoint(point,pointsWithValues,index),point,nextPoint(point,pointsWithValues,index),tension);if(point.controlPoints.outer.y>this.scale.endPoint){point.controlPoints.outer.y=this.scale.endPoint;}
else if(point.controlPoints.outer.y<this.scale.startPoint){point.controlPoints.outer.y=this.scale.startPoint;}
if(point.controlPoints.inner.y>this.scale.endPoint){point.controlPoints.inner.y=this.scale.endPoint;}
else if(point.controlPoints.inner.y<this.scale.startPoint){point.controlPoints.inner.y=this.scale.startPoint;}},this);}
ctx.lineWidth=this.options.datasetStrokeWidth;ctx.strokeStyle=dataset.strokeColor;ctx.beginPath();helpers.each(pointsWithValues,function(point,index){if(index===0){ctx.moveTo(point.x,point.y);}
else{if(this.options.bezierCurve){var previous=previousPoint(point,pointsWithValues,index);ctx.bezierCurveTo(previous.controlPoints.outer.x,previous.controlPoints.outer.y,point.controlPoints.inner.x,point.controlPoints.inner.y,point.x,point.y);}
else{ctx.lineTo(point.x,point.y);}}},this);ctx.stroke();if(this.options.datasetFill&&pointsWithValues.length>0){ctx.lineTo(pointsWithValues[pointsWithValues.length-1].x,this.scale.endPoint);ctx.lineTo(pointsWithValues[0].x,this.scale.endPoint);ctx.fillStyle=dataset.fillColor;ctx.closePath();ctx.fill();}
helpers.each(pointsWithValues,function(point){point.draw();});},this);}});}).call(this);